/******************************************************************************/
class SetInt : BaseEvent
{
public:
            SetInt();
   virtual ~SetInt();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_IntUID;
   VarInt* m_VarInt;
   int m_Value, m_OrigValue;
   ENUM_INT_OPERATIONS m_IntOperation;
   bool m_Wrap;
   int m_WrapMax, m_WrapMin;
};
/******************************************************************************/
SetInt::SetInt() : BaseEvent(), m_Value(0), m_OrigValue(0), m_VarInt(null), m_Wrap(false), m_WrapMax(0), m_WrapMin(0)            
{
   
}
SetInt::~SetInt()
{
   
}
/******************************************************************************/
void SetInt::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("IntOperation")) m_IntOperation = (ENUM_INT_OPERATIONS)p.asEnum();
   if(Param *p = obj.findParam("VarIntUID"))    m_IntUID       = p.asID();
   if(Param *p = obj.findParam("Value"))        m_Value        = p.asBool();
   if(Param *p = obj.findParam("Wrap"))         m_Wrap         = p.asBool();
   if(Param *p = obj.findParam("WrapMaximum"))  m_WrapMax      = p.asInt();
   if(Param *p = obj.findParam("WrapMinimum"))  m_WrapMin      = p.asInt();
   
   m_OrigValue = m_Value;
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SetInt::AfterCreate()
{
   // Find the correct VarInt to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesInt)
      if(variablesInt[i].id() == m_IntUID)
         m_VarInt = &variablesInt[i]; 
         
   DEBUG_ASSERT(m_VarInt, "VarInt not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SetInt::CallTriggeredAction()
{
   int value = m_Value;
   
   if(m_Wrap)
   {   
      int diff = m_WrapMax - m_WrapMin;
      
      while(value > 0 ? m_Value > diff :  m_Value < -diff)
      {
         m_Value > 0 ? value -= diff :  value += diff;
      }  
   }

   int storedValue = m_VarInt->GetValue();
   if(m_IntOperation == INT_SET_VALUE)
   {
      if(m_Wrap)
      {
         value = Clamp(m_Value, m_WrapMin,  m_WrapMax);
      }
      m_VarInt->SetValue(value);
      
      if(m_LogDetailed || m_LogOutput)
      {
         LogN(S+"Start Trigger: Setting VarInt (INFO: " + m_EditorInfo + " ) to: " + value);
      }      
   }
   else if(m_IntOperation == INT_ADD_VALUE)
   {
      if(m_Wrap)
      {
         int leftToAdd = value;
         int currValue = storedValue;
         bool positive = leftToAdd > 0;
         
         while(positive ? leftToAdd > 0 : leftToAdd < 0)
         {
            positive ? leftToAdd-- : leftToAdd++;
            
            if(positive ? currValue < m_WrapMax :  currValue > m_WrapMin)
            {
               positive ? currValue++ : currValue--;
            }
            else
            {
               currValue = positive ? m_WrapMin : m_WrapMax;
            }
         }
         m_VarInt->SetValue(currValue);
         
         if(m_LogDetailed || m_LogOutput)
         {
            LogN(S+"Start Trigger: Incrementing VarInt (INFO: " + m_EditorInfo + " ) with: " + value + ", from: " + m_Value + ", to: " + currValue);
         }         
      }
      else
      {
         if(m_LogDetailed || m_LogOutput)
         {
            LogN(S+"Start Trigger: Incrementing VarInt (INFO: " + m_EditorInfo + " ) with: " + m_Value + ", from: " + m_VarInt->GetValue() + ", to: " + (m_VarInt->GetValue() + m_Value));
         }
         
         m_VarInt->AddValue(m_Value);    
      }
   }
   
}

// This method is called when the duration of the event has been reached
void SetInt::StopTriggeredAction()
{
   if(m_LogDetailed || m_LogOutput)
   {
      LogN(S+" Stop Trigger: Setting VarInt (INFO: " + m_EditorInfo + " ) with: " + m_VarInt->GetValue() + ", to: " + m_OrigValue);
   }
   
   // If m_Duration is not -1, the int will be set back to its original value, after a while
   m_VarInt->SetValue(m_OrigValue); 
}
/******************************************************************************/